//was muss importet werden?

//als erstes alle klassen die wir uns geschrieben haben
import EINGABE.*;
import PERIODENSYSTEM.*;
import BAUM.*;
//dann die sun packages um das bild zu codieren
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
//dann die awt packages fr die oberflche
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
//und natrlich die IO-packages
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

/**
 *
 * @author  Martin Scharm, Christoph Ruttkies, Steffi Dornfeldt
 */

public class MAIN extends javax.swing.JFrame
{
    //die internen speichervariablen
    
    //das Periodensystem brauchen wir auch in den andern klassen
    //daher public
    public PerSys per;
    
    //die farben fr die grafik
    private Color hintergrund;
    private Color achsen;
    private Color werte;
    private Color balken;
    private Color copyright;
    private Color hintergrund_highlight;
    private Color verb_name;

    //die bool variablen um zu gucken was gezeichnet werden soll
    private boolean correct;
    private boolean info;

    //und die werte die beim berechnen heraus kamen
    private Node [] final_values;
    private double min_weight;
    private double max_weight;
    private double max_percent;

    // die oberflchencomponenten...
    private javax.swing.JTextArea A_AUSGABE;
    private javax.swing.JButton B_ALLISOS;
    private javax.swing.JButton B_BERECHNE;
    private javax.swing.JButton B_COPY;
    private javax.swing.JButton B_INFO;
    private javax.swing.JButton B_SAVE;
    private javax.swing.JCheckBox C_100;
    private javax.swing.JCheckBox C_LABEL;
    private javax.swing.JCheckBox C_RESOLUTION;
    private javax.swing.JCheckBox C_VERB_ANZ;
    private javax.swing.JTextField F_EINGABE;
    private javax.swing.JTextField F_VERB_ANZ;
    private javax.swing.JTabbedPane IsotopenBerechnung;
    private javax.swing.JSeparator LINE1;
    private javax.swing.JSeparator LINE2;
    private javax.swing.JLabel L_1;
    private javax.swing.JLabel L_2;
    private javax.swing.JLabel L_3;
    private javax.swing.JLabel L_4;
    private javax.swing.JLabel L_5;
    private javax.swing.JLabel L_6;
    private javax.swing.JScrollPane SCROLLING;
    private javax.swing.JPanel TAB;
    
    /** 
     * Erzeugt das Programm
     * -> Componenten initialisieren
     * -> Listener setzen
     * -> Variablen definieren
     * -> Fenster aufbauen
     */
    public MAIN ()
    {
	//initialisieren der componenten der oberflche
	initComponents ();
	//den componenten ihre listener anhngen
	setListener ();
	//das periodensystem einlesen und speichern
	install ();
	//und die startgrafik malen
	repaint();
    }
    
    //die oberflchencomponenten mssen initialisiert werden
    //und wir mssen ihnen sagen wo sie auf der oberflche stehen drfen^^
    private void initComponents()
    {
        IsotopenBerechnung = new javax.swing.JTabbedPane();
        TAB = new javax.swing.JPanel();
        L_1 = new javax.swing.JLabel();
        F_EINGABE = new javax.swing.JTextField();
        B_BERECHNE = new javax.swing.JButton();
        B_ALLISOS = new javax.swing.JButton();
        B_INFO = new javax.swing.JButton();
        LINE1 = new javax.swing.JSeparator();
        L_2 = new javax.swing.JLabel();
        SCROLLING = new javax.swing.JScrollPane();
        A_AUSGABE = new javax.swing.JTextArea();
        C_LABEL = new javax.swing.JCheckBox();
        C_100 = new javax.swing.JCheckBox();
        C_VERB_ANZ = new javax.swing.JCheckBox();
        L_3 = new javax.swing.JLabel();
        F_VERB_ANZ = new javax.swing.JTextField();
        C_RESOLUTION = new javax.swing.JCheckBox();
        B_SAVE = new javax.swing.JButton();
        B_COPY = new javax.swing.JButton();
        L_4 = new javax.swing.JLabel();
        L_5 = new javax.swing.JLabel();
        L_6 = new javax.swing.JLabel();
        LINE2 = new javax.swing.JSeparator();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        L_1.setText("Verbindung eingeben:");

        B_BERECHNE.setText("Berechne");

        B_ALLISOS.setText("Alle Isotopen");

        B_INFO.setText("Info");

        L_2.setText("Isotopen der Verbindung:");

        A_AUSGABE.setColumns(20);
        A_AUSGABE.setRows(5);
        SCROLLING.setViewportView(A_AUSGABE);

        C_LABEL.setText("Labels anzeigen");
        C_LABEL.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        C_LABEL.setMargin(new java.awt.Insets(0, 0, 0, 0));

        C_100.setText("auf 100% rechnen");
        C_100.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        C_100.setMargin(new java.awt.Insets(0, 0, 0, 0));

        C_VERB_ANZ.setText("Verbindung in der Grafik anzeigen");
        C_VERB_ANZ.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        C_VERB_ANZ.setMargin(new java.awt.Insets(0, 0, 0, 0));

        L_3.setText("Alternativer Name:");

        C_RESOLUTION.setText("Hohe Aufl\u00f6sung");
        C_RESOLUTION.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        C_RESOLUTION.setMargin(new java.awt.Insets(0, 0, 0, 0));

        B_SAVE.setText("Grafik speichern");

        B_COPY.setText("Tabelle kopieren");

        L_4.setText("Grafisch:");

        L_5.setText("Status:");

        //jetzt haben wir allen gesagt was sie sind, jetzt
        //mssen sie nur noch wissen wo sie hingehren...
        javax.swing.GroupLayout TABLayout = new javax.swing.GroupLayout(TAB);
        TAB.setLayout(TABLayout);
        TABLayout.setHorizontalGroup(
            TABLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(TABLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(TABLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(LINE2, javax.swing.GroupLayout.DEFAULT_SIZE, 861, Short.MAX_VALUE)
                    .addComponent(L_1, javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, TABLayout.createSequentialGroup()
                        .addComponent(F_EINGABE, javax.swing.GroupLayout.PREFERRED_SIZE, 382, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(B_BERECHNE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(B_ALLISOS)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(B_INFO))
                    .addComponent(LINE1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 861, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, TABLayout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addGroup(TABLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(TABLayout.createSequentialGroup()
                                .addComponent(L_5)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(L_6))
                            .addGroup(TABLayout.createSequentialGroup()
                                .addComponent(SCROLLING, javax.swing.GroupLayout.PREFERRED_SIZE, 231, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(87, 87, 87)
                                .addGroup(TABLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(C_100)
                                    .addComponent(C_LABEL)
                                    .addComponent(C_VERB_ANZ)
                                    .addGroup(TABLayout.createSequentialGroup()
                                        .addGap(17, 17, 17)
                                        .addComponent(L_3)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(F_VERB_ANZ, javax.swing.GroupLayout.PREFERRED_SIZE, 210, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addComponent(C_RESOLUTION)
                                    .addGroup(TABLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                        .addComponent(B_SAVE, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(B_COPY, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                            .addComponent(L_2)
                            .addComponent(L_4))
                        .addGap(211, 211, 211)))
                .addContainerGap())
        );
        TABLayout.setVerticalGroup(
            TABLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(TABLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(L_1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(TABLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(F_EINGABE, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(B_BERECHNE)
                    .addComponent(B_ALLISOS)
                    .addComponent(B_INFO))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(LINE1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(L_2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(TABLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(TABLayout.createSequentialGroup()
                        .addComponent(C_LABEL)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(C_100)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(C_VERB_ANZ)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(TABLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(L_3)
                            .addComponent(F_VERB_ANZ, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(C_RESOLUTION)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(B_COPY)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(B_SAVE))
                    .addComponent(SCROLLING, javax.swing.GroupLayout.PREFERRED_SIZE, 201, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE)
                .addComponent(L_4)
                .addGap(301, 301, 301)
                .addComponent(LINE2, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGroup(TABLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(TABLayout.createSequentialGroup()
                        .addGap(4, 4, 4)
                        .addComponent(L_5))
                    .addGroup(TABLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(L_6, javax.swing.GroupLayout.DEFAULT_SIZE, 12, Short.MAX_VALUE)))
                .addContainerGap())
        );
        IsotopenBerechnung.addTab("IsotopenBerechnung", TAB);

        IsotopenBerechnung.getAccessibleContext().setAccessibleName("IsotopenBerechnung");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(IsotopenBerechnung, javax.swing.GroupLayout.DEFAULT_SIZE, 886, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(IsotopenBerechnung, javax.swing.GroupLayout.DEFAULT_SIZE, 710, Short.MAX_VALUE)
                .addContainerGap())
        );
        pack();
    }//jetzt sind die componenten initialisiert...
     //und das tool ist bereit zu arbeiten
    
    //hier werden den Componenten die listener angehngt
    //um auf interaktionen des benutzers reagieren zu knnen
    private void setListener()
    {
	//wenn das fenster deaktiviert war und wieder aktiviert wird,
	//muss die grafik neu gemalt werden -> repaint
	addWindowListener(new java.awt.event.WindowAdapter() {
	    public void windowActivated(java.awt.event.WindowEvent evt) {
		repaint();
	    }
	});
	//ebenso wenn die fenstergre gendert wird oder das fenster bewegt wird...
	addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener() {
	    public void ancestorMoved(java.awt.event.HierarchyEvent evt) {
		repaint();
	    }
	    public void ancestorResized(java.awt.event.HierarchyEvent evt) {
		repaint();
	    }
	});
	//der mouselistener fr den berechnen-button
	B_BERECHNE.addMouseListener(new java.awt.event.MouseAdapter() {
	    public void mouseClicked(java.awt.event.MouseEvent evt) {
		rechne();
	    }
	});
	//action wenn auf button info geklickt wird
	B_INFO.addMouseListener(new java.awt.event.MouseAdapter() {
	    public void mouseClicked(java.awt.event.MouseEvent evt) {
		info = true;
		A_AUSGABE.setText ("Eingabe muss case senitive erfolgen\n\n" +
			"Die Grafik wird im aktuellen\nVerzeichnis gespeichert!" +
			"\n\n\nweitere Informationen unter\n" +
			"www.iso2l.de.vu");
		L_6.setText("Gib eine Verbindung ein und klicke Berechnen!                  ");
		repaint();
	    }
	});
	//action wenn auf button alle isotope anzeigen geklickt wird
	B_ALLISOS.addMouseListener(new java.awt.event.MouseAdapter() {
	    public void mouseClicked(java.awt.event.MouseEvent evt) {
		info = true;
		String ausgabe = "";
		for (int j = 1; j < per.elemente.length; j++) {
		    Isotops [] Li = per.elemente[j].isos.gib_isos();
		    int laenge = Li.length;
		    ausgabe += "\n" + per.elemente[j].name + "\n";
		    for (int k = 0; k < laenge; k++) {
			ausgabe += "Prozent " + Li[k].percent;
			ausgabe += ", Gewicht " + Li[k].weight + "\n";
		    }
		}
		A_AUSGABE.setText(ausgabe);
		correct = false;
		L_6.setText("Gib eine Verbindung ein und klicke Berechnen!                  ");
		repaint();
	    }
	});
	//action beim klick auf copy -> copy to clipboard
	B_COPY.addMouseListener(new java.awt.event.MouseAdapter() {
	    public void mouseClicked(java.awt.event.MouseEvent evt) {
		StringSelection text = new StringSelection(A_AUSGABE.getText());
		Toolkit.getDefaultToolkit().getSystemClipboard().setContents(text, null);
	    }
	});
	//action bei klick auf grafik speichern
	//screenshot -> code to jpg -> save
	B_SAVE.addMouseListener(new java.awt.event.MouseAdapter() {
	    public void mouseClicked(java.awt.event.MouseEvent evt) {
		//AUSGABE.setText ("" + this.getLocation ()getLocation ().x);
		BufferedImage screenshot;
		try 
		{
		    screenshot = (new Robot()).createScreenCapture(
			    new Rectangle(getLocation ().x + 50, getLocation ().y + 400, 700, 270));

		    // in die Datei test.jpg schreiben:
		    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream("iso2l_Grafik.jpg")) ;
		    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out) ;
		    encoder.encode(screenshot) ;
		    out.close() ;
		} 
		catch (AWTException ex)
		{
		    A_AUSGABE.setText (ex.toString ());
		} catch (FileNotFoundException ex)
		{
		    A_AUSGABE.setText (ex.toString ());
		} catch (ImageFormatException ex)
		{
		    A_AUSGABE.setText (ex.toString ());
		} catch (IOException ex)
		{
		    A_AUSGABE.setText (ex.toString ());
		}
	    }
	});
	//zum schluss bekommt noch das eingabefeld
	//einen keylistener damit auch mit ENTER
	//berechnet wird
        F_EINGABE.addKeyListener(new KeyListener() {

            public void keyTyped(KeyEvent e) {}

            public void keyPressed(KeyEvent e)
	    {
                if (e.getKeyCode() == KeyEvent.VK_ENTER)
                {
                    rechne();
                }
            }

            public void keyReleased(KeyEvent e) {}
        });
    }//ende der listener
    
    /**
     * @param args the command line arguments
     * Die Main zum Starten der Programms
     */
    public static void main (String args[])
    {
	java.awt.EventQueue.invokeLater (new Runnable ()
	{
	    public void run ()
	    {
		new MAIN ().setVisible (true);
	    }
	});
    }
    
    /**
     * Die Paint() - Funktion ausjava.awt.Container berschrieben
     **/
    public void paint(Graphics g)
    {
	//die paintfunktion aus der oberklasse aufrufen
	//ansonsten wird - warum auch immer - die grafik
	//nicht ordentlich gemalt
        super.paint(g);
	//die farbe fr den hintergrund setzen
	g.setColor(hintergrund);
	//und den hintergrund malen
	//in form eines rechtecks, hier werden dann das
	//achsenkreuz und die balken etc. daruf gemalt
	g.fillRect (50, 400, 700, 270);
	//wenn das programm startet oder der info-button geklickt wurde
	//besteht die Grafik aus einem Info-Text, dann ist info true
        if (info)
        {
	    //die schriftfarbe einstellen
            g.setColor(new Color(40,70,255));
	    //die schriftart einstellen
            Font schrift = new Font("Arial", 1, 30);
	    //die schriftart setzen
            g.setFont (schrift);
	    //und schreiben
            g.drawString("Das IsotopenBerechnungsTool!",120,500);
	    
	    //quivalent zu oben
            g.setColor(new Color(90,120,255));
            schrift = new Font("Arial", 1, 14);
            g.setFont (schrift);
            g.drawString("Entwickler:",200,550);
            g.drawString("Martin Scharm",210,565);
            g.drawString("Christoph Ruttkies",210,580);
            g.drawString("Steffi Dornfeldt",210,595);
            g.drawString("fr weitere Informationen",410,550);
            g.drawString("und Updates:",410,565);
            g.setColor(new Color(80,100,245));
            schrift = new Font("Arial", 1, 14);
            g.drawString("www.iso2l.de.vu",450,580);
        }
	//wenn der info-text nicht angezeigt wird, die eingegeben
	//verbindung aber nicht korrekt ist
        else if (!correct)
        {
	    //quivalent zu oben
            g.setColor(balken);	    
            Font schrift = new Font("Arial", 1, 30);
            g.setFont (schrift);
	    //die fehlermeldung
            g.drawString("Keine Korrekte Verbindung!",200,500);
            
        }
        else //wenn die verbindung korrekt ist
        {
	    //bestimmen der eckpunkte des koordinatensystems
	    //um nachher variabel arbeiten zu knnen
            int left = 105;
            int right = 705;
            int up = 440;
            int down = 640;
	    //die farbe fr den gehighlighteten hintergrund setzen
            g.setColor(hintergrund_highlight);
	    //zur besseren bersicht werden hier rechtecke angelegt,
	    //die das ablesen erleichtern sollen
	    // (eines von 25-50% und eines von 75-100%)
            g.fillRect (left, up, right-left, (int)((down-up) / 4));
            g.fillRect (left, (int)((up + down) / 2), right-left, (int)((down-up) / 4));
	    //die achsenfarbe einstellen
            g.setColor(achsen);
	    //koordinatensystem malen
	    //die horizontale achse
	    g.drawLine(left,down,right,down);
	    //die vertikale achse
	    g.drawLine(left,up,left,down);
	    //und jetzt tragen wir gleich 50% und 100% ab
	    //da die immer an der selben statischen stelle stehen
	    g.drawLine(left-5,up,left,up);
	    g.drawLine(left-5,(up + down) / 2,left,(up + down) / 2);
	    g.drawString("100%",left-38,up + 5);
	    g.drawString("50%",left-33,(up + down) / 2 + 5);
	    //der bereich in dem wir uns bewegen knnen wird ausgerechnet
            int bereich = right - left;
	    //jetzt bestimmen wir die anzahl der gewichte die wir auf der
	    //horizontalen abtragen mssen
            int steps = (int)(max_weight - min_weight + 2);
	    //jetzt wird die schrittgre zwischen zwei  ausgerechnet
            double steplength = bereich / steps;
	    //und wird die horizontale beschriftet
            for (int i = 1; i < steps; i++)
            {
		//die pixelstelle auf der achse bestimmen
                int wo = (int)(i * steplength + left);
		//kleine linie nach unten malen
		g.drawLine(wo,down,wo,down+5);
		//wert dran schreiben
                g.drawString(Integer.toString((int)min_weight-1+i),wo-8,down+18);
            }
	    //der standartfaktor ist 1
	    double faktor = 1.0;
	    //mchte der benutzer den hchsten wert als 100% setzen
	    //wird hier der relative faktor ausgerechnet, um den jeder
	    //prozentwerde erweitert werden muss
	    if (C_100.isSelected ()) faktor = 100 / max_percent;
	    //die farbe fr die balken setzen
            g.setColor(balken);
	    //jetzt malen wir die balken ein
	    //eine for-schleife die durdch den vektor geht
            for (int i = 0; i < final_values.length; i++)
            {
		//die stelle auf der achse berechnen
                int wo = (int)((final_values[i].weight - min_weight + 1) * steplength + left);
		//den balken malen
		g.drawLine(wo,down,wo,up + 200 - (int)(final_values[i].percent * 2 * faktor));
		//wenn labels gewnscht werden -> ber den balken schreiben
                if (C_LABEL.isSelected ()) g.drawString("" + final_values[i].weight, wo - 8, up + 196 - (int)(final_values[i].percent * 2 * faktor));
            }
	    //wenn die Verbindung in der grafik angezeigt werden soll
            if (C_VERB_ANZ.isSelected ())
	    {
		//setzen der farbe
		g.setColor(verb_name);
		//setzen der schriftart
		Font schrift = new Font("Arial", 1, 15);
		g.setFont (schrift);
		g.setColor(verb_name);
		//gucken ob alternativ name angegeben ist, ansonsten die eingegebene verbindung anzeigen
		if (F_VERB_ANZ.getText ().equals ("")) g.drawString("Verbindung: " + F_EINGABE.getText(),120,420);
		else g.drawString("Verbindung: " + F_VERB_ANZ.getText(),120,420);
	    }
        }
    }//ende paint
    
    
    //ntige funktionen
    /**
     * berechnen der isotope der Verbindung
     */
    public void rechne()
    {                   
	//als erstes wird info auf false gesetzt,
	//da ab hier nichtmehr die infoseite angezeigt werden soll
	//ab hier is die verbindung entweder richtig oder falsch
        info = false;
	//die eingabe auslesen
        String eingabe = F_EINGABE.getText();
	//ausgabe vorerst leer
        String ausgabe = "";
	//ein objekt der eingabeklasse erzeugen
        eingabe in = new eingabe();
	//status setzen
        L_6.setText("Eingabe wird berprft!                  ");
	//und die eingabe berprfen
        Vector rueckgabe = in.scan(eingabe, per);
	//wenn der vektor null ist, ist die eingabe nicht korrekt...
        if (rueckgabe == null)
        {
	    //fehler in der ausgabe
            ausgabe = "Falsche Eingabe!";
	    //fehler im status
            L_6.setText("Die Eingabe ist nicht korrekt, versuchs nochmal!                  ");
	    //verbindung ist falsch
            correct = false;
	    //und fehler in der grafik
            repaint();
        } 
        else //der rckgabe vektor ist nicht null
	    //jetzt kann nichts mehr schiefgehen ;)
        {
	    //einen baum anlegen
	    Tree baum = new Tree();
	    //status setzen
            L_6.setText("Isotopen werden berechnet!                  ");
	    //erstellen wir einen vektor, in dem die ausgerechneten
	    //isotope des baums gespeichert werden
            Vector stoffi = baum.mach_ausrechnen(rueckgabe, per);
	    //der vektor mit den final_values bekommt jetzt
	    //die werte die wir aus den Isotopen vom baum
	    //ermittelft haben
            final_values = zauber(stoffi);
	    //staus setzen
            L_6.setText("Tabelle wird erstellt!                  ");
	    //jetzt wird die ausgabe bestimmt
	    //einfach for schleife ber vektor
	    //ausgabestring fllen
            for (int i = 0; i < final_values.length; i++) {
                ausgabe += "\nIsotop " + (i+1) + "\n";
                ausgabe += "\nProzent: " + final_values[i].percent;
                ausgabe += "\nGewicht: " + final_values[i].weight;
                ausgabe += "\n";
            }
	    //status setzen
            L_6.setText("Bild wird gemalt!                  ");
	    //verbindung ist korrekt
            correct = true;
	    //bild neu malen
            repaint();
	    //status setzen -> fertig
            L_6.setText("Fertig!                  ");
        }
	//ausgabe ins textfeld schreiben
        A_AUSGABE.setText(ausgabe);
    }//ende rechne

    //diese funktion "zaubert" aus den isotopen
    //1. das hchste gewicht	-> fr grafik malen
    //2. das niedrigste gewicht	-> fr grafik malen
    //3. die hchste prozentzahl-> um auf 100% aufrunden zu knnen
    //4. rundet die prozentzahlen und gewichte
    private Node[] zauber(Vector stoffi)
    {
	//dazu erffnen wir einen neuen vektor, genauso gro wie der alte
        Node [] staffi = new Node [stoffi.size()];
	//die max-werte nehmen die werte des ersten elements an
        max_weight = ((Node)stoffi.elementAt(0)).weight;
        min_weight = ((Node)stoffi.elementAt(0)).weight;
        max_percent = ((Node)stoffi.elementAt(0)).percent;
	//und jetzt luft eine schleife der den vektor
        for (int i = 0; i < stoffi.size(); i++)
        {
	    //der neue vektor bekommt ein neues element
	    //mit den werten aus dem alten vektor, die prozentzahl
	    //wird jedoch auf 2 stellen nach dem komma gerundet
            staffi[i] = new Node();
            staffi[i].percent = Math.round(((Node)stoffi.elementAt(i)).percent * 100. * 100.) / 100.;
            staffi[i].weight = ((Node)stoffi.elementAt(i)).weight;
	    //wenn keine hohe auflsung gewnscht ist
	    //wird das gewicht auch gerundet, auf eine ganze zahl
            if (!C_RESOLUTION.isSelected ())
            {
                staffi[i].weight = Math.round(staffi[i].weight);
            }
	    //jetzt wird noch berprft ob die max/min-werte noch aktuell sind
	    //wenn nich -> aktualisieren
            if (staffi[i].weight > max_weight) max_weight = staffi[i].weight;
            if (staffi[i].weight < min_weight) min_weight = staffi[i].weight;
            if (staffi[i].percent > max_percent) max_percent = staffi[i].percent;
        }
	//wenn keine hohe auflsung mssen wir noch berprfen ob einige gerundete
	//werte doppelt vor kommen, denn aus 14.1 und 14.2 wird jeweils 14 mit unterschiedlichen
	//prozenten -> das kontrolliert nun watch()
        if (!C_RESOLUTION.isSelected ())
        {
            staffi = watch(staffi);
        }
        //und der neue vektor wird zurck gegeben
        return staffi;
    }//ende zauber
    //die watch()-methode berprft den vektor auf doppelte gewichte
    private Node[] watch(Node [] doppelte)
    {
	//neuen vektor erstellen
        Vector tmp = new Vector();
	//bool variable einfhren
        boolean found = false;
	//schleife ber den ausgangsvektor laufen lassen
        for (int i = 0; i < doppelte.length; i++)
        {
            found = false;
	    //schleife ber den neuen vektor laufen lassen
            for (int j = 0; j < tmp.size(); j++)
            {
		//wenn das element im neuen vektor einem element
		//im ausgangsvektor entspricht kommt es doppelt vo
		//und die prozentzahlen werden addiert und im neuen vektor gespeichert
               if (((Node)tmp.elementAt(j)).weight == doppelte[i].weight) 
               {
		   //anpassen
                   ((Node)tmp.elementAt(j)).percent = Math.round((((Node)tmp.elementAt(j)).percent + doppelte[i].percent) * 100.) / 100.;
		   //das element wurde gefunden
                   found = true;
		   //schleife kann abgebrochen werden
                   break;
               }
            }
            //wenn das element nicht gefunden wurde, wird es jetzt
	    //in den neuen vektor geschrieben
	    if (!found) tmp.add(doppelte[i]);
        }
	//nun mssen die max/min-werte natrlich auch noch angepasst werden
	//und wir wollen alles in einem array haben -> array erstellen
        Node [] stuffi = new Node[tmp.size()];
        //startwerte fr max/min setzen
        max_weight = ((Node)tmp.elementAt(0)).weight;
        min_weight = ((Node)tmp.elementAt(0)).weight;
        max_percent = ((Node)tmp.elementAt(0)).percent;
	//ber den vektor laufen
        for (int j = 0; j < tmp.size(); j++)
        {
	    //aktuelles vektorelement ins array schreiben
            stuffi[j] = new Node();
            stuffi[j].percent = ((Node)tmp.elementAt(j)).percent;
            stuffi[j].weight = ((Node)tmp.elementAt(j)).weight;
	    //max/min anpassen
            if (stuffi[j].weight > max_weight) max_weight = stuffi[j].weight;
            if (stuffi[j].weight < min_weight) min_weight = stuffi[j].weight;
            if (stuffi[j].percent > max_percent) max_percent = stuffi[j].percent;
        }
	//und nun das array zurck geben
        return stuffi;
    }//ende watch
    
    //die install
    private void install()
    {
        //die eigenen einstellungen
        hintergrund = new Color (255,255,255);
        hintergrund_highlight = new Color (240,240,240);
        achsen = new Color (0,0,0);
        werte = new Color (0,0,0);
        balken = new Color (0,0,0);
        copyright = new Color (240,240,240);
        verb_name = new Color (0,0,0);
        correct = false;
        info = true;
        L_6.setText("Gib eine Verbindung ein und klicke Berechnen!                  ");
        
        per = new PerSys (93);
        int i = 0;
        //und das periodensystem einlesen
        per.elemente[i].elekneg = 2.1;
        per.elemente[i].name = "Deuterium";
        per.elemente[i].zeichen = "D";
        per.elemente[i].isos.nach_hinten(1.0, 2.014102);
	i++;
        per.elemente[i].elekneg = 2.1;
        per.elemente[i].name = "Wasserstoff";
        per.elemente[i].zeichen = "H";
        per.elemente[i].isos.nach_hinten(0.99985, 1.007825);
        per.elemente[i].isos.nach_hinten(0.00015, 2.014102);
	i++;
        per.elemente[i].elekneg = 0;
        per.elemente[i].name = "Helium";
        per.elemente[i].zeichen = "He";
        per.elemente[i].isos.nach_hinten(0.0000014, 3.016029);
        per.elemente[i].isos.nach_hinten(0.9999986, 4.002603);
	i++;
        per.elemente[i].elekneg = 1.0;
        per.elemente[i].name = "Lithium";
        per.elemente[i].zeichen = "Li";
        per.elemente[i].isos.nach_hinten(0.0742, 6.015123);
        per.elemente[i].isos.nach_hinten(0.9258, 7.016005);
	i++;
        per.elemente[i].elekneg = 1.5;
        per.elemente[i].name = "Beryllium";
        per.elemente[i].zeichen = "Be";
        per.elemente[i].isos.nach_hinten(1, 9.012183);
	i++;
        per.elemente[i].elekneg = 2.0;
        per.elemente[i].name = "Bor";
        per.elemente[i].zeichen = "B";
        per.elemente[i].isos.nach_hinten(0.198, 10.012938);
        per.elemente[i].isos.nach_hinten(0.802, 11.009305);
	i++;
        per.elemente[i].elekneg = 2.5;
        per.elemente[i].name = "Kohlenstoff";
        per.elemente[i].zeichen = "C";
        per.elemente[i].isos.nach_hinten(0.989, 12.0);
        per.elemente[i].isos.nach_hinten(0.011, 13.003355);
	i++;
        per.elemente[i].elekneg = 3.0;
        per.elemente[i].name = "Stickstoff";
        per.elemente[i].zeichen = "N";
        per.elemente[i].isos.nach_hinten(0.9963, 14.003074);
        per.elemente[i].isos.nach_hinten(0.0037, 15.000109);
	i++;
        per.elemente[i].elekneg = 3.5;
        per.elemente[i].name = "Sauerstoff";
        per.elemente[i].zeichen = "O";
        per.elemente[i].isos.nach_hinten(0.99761, 15.994915);
        per.elemente[i].isos.nach_hinten(0.00038, 16.999131);
        per.elemente[i].isos.nach_hinten(0.00201, 17.999159);
	i++;
        per.elemente[i].elekneg = 4.0;
        per.elemente[i].name = "Fluor";
        per.elemente[i].zeichen = "F";
        per.elemente[i].isos.nach_hinten(1, 18.998403);
	i++;
        per.elemente[i].elekneg = 0.0;
        per.elemente[i].name = "Neon";
        per.elemente[i].zeichen = "Ne";
        per.elemente[i].isos.nach_hinten(0.906, 19.992439);
        per.elemente[i].isos.nach_hinten(0.0026, 20.993845);
        per.elemente[i].isos.nach_hinten(0.092, 21.991384);
	i++;
        per.elemente[i].elekneg = 0.9;
        per.elemente[i].name = "Natrium";
        per.elemente[i].zeichen = "Na";
        per.elemente[i].isos.nach_hinten(1, 22.988970);
	i++;
        per.elemente[i].elekneg = 1.2;
        per.elemente[i].name = "Magnesium";
        per.elemente[i].zeichen = "Mg";
        per.elemente[i].isos.nach_hinten(0.789, 23.985046);
        per.elemente[i].isos.nach_hinten(0.1, 24.985839);
        per.elemente[i].isos.nach_hinten(0.111, 25.982595);
	i++;
        per.elemente[i].elekneg = 1.5;
        per.elemente[i].name = "Aluminium";
        per.elemente[i].zeichen = "Al";
        per.elemente[i].isos.nach_hinten(1.0, 26.981541);
	i++;
        per.elemente[i].elekneg = 1.80;
        per.elemente[i].name = "Silicium";
        per.elemente[i].zeichen = "Si";
        per.elemente[i].isos.nach_hinten(0.9223, 27.976928);
        per.elemente[i].isos.nach_hinten(0.0467, 28.976496);
        per.elemente[i].isos.nach_hinten(0.0310, 29.973770);
	i++;
        per.elemente[i].elekneg = 2.10;
        per.elemente[i].name = "Phosphor";
        per.elemente[i].zeichen = "P";
        per.elemente[i].isos.nach_hinten(1, 30.973763);
	i++;
        per.elemente[i].elekneg = 2.50;
        per.elemente[i].name = "Schwefel";
        per.elemente[i].zeichen = "S";
        per.elemente[i].isos.nach_hinten(0.9502, 31.972072);
        per.elemente[i].isos.nach_hinten(0.0075, 32.971459);
        per.elemente[i].isos.nach_hinten(0.0421, 33.967866);
        per.elemente[i].isos.nach_hinten(0.0002, 35.967079);
	i++;
        per.elemente[i].elekneg = 3.0;
        per.elemente[i].name = "Chlor";
        per.elemente[i].zeichen = "Cl";
        per.elemente[i].isos.nach_hinten(0.7577, 34.968853);
        per.elemente[i].isos.nach_hinten(0.2423, 36.965903);
	i++;
        per.elemente[i].elekneg = 0.0;
        per.elemente[i].name = "Argon";
        per.elemente[i].zeichen = "Ar";
        per.elemente[i].isos.nach_hinten(0.0034, 35.967546);
        per.elemente[i].isos.nach_hinten(0.00063, 37.962732);
        per.elemente[i].isos.nach_hinten(0.9960, 39.962384);
	i++;
        per.elemente[i].elekneg = 0.80;
        per.elemente[i].name = "Kalium";
        per.elemente[i].zeichen = "K";
        per.elemente[i].isos.nach_hinten(0.9320, 38.963708);
        per.elemente[i].isos.nach_hinten(0.00012, 39.963999);
        per.elemente[i].isos.nach_hinten(0.0673, 40.961825);
	i++;
        per.elemente[i].elekneg = 1.0;
        per.elemente[i].name = "Calcium";
        per.elemente[i].zeichen = "Ca";
        per.elemente[i].isos.nach_hinten(0.9695, 39.962591);
        per.elemente[i].isos.nach_hinten(0.0065, 41.958622);
        per.elemente[i].isos.nach_hinten(0.0014, 42958766.);
        per.elemente[i].isos.nach_hinten(0.0286, 43.955485);
        per.elemente[i].isos.nach_hinten(0.00004, 45.953689);
        per.elemente[i].isos.nach_hinten(0.0019, 47.952532);
	i++;
        per.elemente[i].elekneg = 1.30;
        per.elemente[i].name = "Scandium";
        per.elemente[i].zeichen = "Sc";
        per.elemente[i].isos.nach_hinten(1, 44.955914);
	i++;
        per.elemente[i].elekneg = 1.50;
        per.elemente[i].name = "Titan";
        per.elemente[i].zeichen = "Ti";
        per.elemente[i].isos.nach_hinten(0.08, 45.952633);
        per.elemente[i].isos.nach_hinten(0.073, 46.951765);
        per.elemente[i].isos.nach_hinten(0.738, 47.947947);
        per.elemente[i].isos.nach_hinten(0.055, 48.947871);
        per.elemente[i].isos.nach_hinten(0.054, 49.944786);
	i++;
        per.elemente[i].elekneg = 1.60;
        per.elemente[i].name = "Vanadium";
        per.elemente[i].zeichen = "V";
        per.elemente[i].isos.nach_hinten(0.0025, 49.947161);
        per.elemente[i].isos.nach_hinten(0.9975, 50.943963);
	i++;
        per.elemente[i].elekneg = 1.60;
        per.elemente[i].name = "Chrom";
        per.elemente[i].zeichen = "Cr";
        per.elemente[i].isos.nach_hinten(0.0435, 49.946046);
        per.elemente[i].isos.nach_hinten(0.8379, 51.940510);
        per.elemente[i].isos.nach_hinten(0.095, 52.940651);
        per.elemente[i].isos.nach_hinten(0.0236, 53.938882);
	i++;
        per.elemente[i].elekneg = 1.50;
        per.elemente[i].name = "Mangan";
        per.elemente[i].zeichen = "Mn";
        per.elemente[i].isos.nach_hinten(1, 54.938046);
	i++;
        per.elemente[i].elekneg = 1.80;
        per.elemente[i].name = "Eisen";
        per.elemente[i].zeichen = "Fe";
        per.elemente[i].isos.nach_hinten(0.058, 53.939612);
        per.elemente[i].isos.nach_hinten(0.9172, 55.934939);
        per.elemente[i].isos.nach_hinten(0.022, 56.935396);
        per.elemente[i].isos.nach_hinten(0.0028, 57.933278);
	i++;
        per.elemente[i].elekneg = 1.80;
        per.elemente[i].name = "Cobalt";
        per.elemente[i].zeichen = "Co";
        per.elemente[i].isos.nach_hinten(1, 58.933198);
	i++;
        per.elemente[i].elekneg = 1.80;
        per.elemente[i].name = "Nickel";
        per.elemente[i].zeichen = "Ni";
        per.elemente[i].isos.nach_hinten(0.6827, 57.935347);
        per.elemente[i].isos.nach_hinten(0.2610, 59.930789);
        per.elemente[i].isos.nach_hinten(0.0113, 60.931058);
        per.elemente[i].isos.nach_hinten(0.0359, 61.928346);
        per.elemente[i].isos.nach_hinten(0.0091, 63.927968);
	i++;
        per.elemente[i].elekneg = 1.90;
        per.elemente[i].name = "Kupfer";
        per.elemente[i].zeichen = "Cu";
        per.elemente[i].isos.nach_hinten(0.6917, 62.929599);
        per.elemente[i].isos.nach_hinten(0.3083, 64.927792);
	i++;
        per.elemente[i].elekneg = 1.60;
        per.elemente[i].name = "Zink";
        per.elemente[i].zeichen = "Zn";
        per.elemente[i].isos.nach_hinten(0.486, 63.929145);
        per.elemente[i].isos.nach_hinten(0.279, 65.926035);
        per.elemente[i].isos.nach_hinten(0.041, 66.927129);
        per.elemente[i].isos.nach_hinten(0.188, 67.924846);
        per.elemente[i].isos.nach_hinten(0.006, 69.925325);
	i++;
        per.elemente[i].elekneg = 1.60;
        per.elemente[i].name = "Gallium";
        per.elemente[i].zeichen = "Ga";
        per.elemente[i].isos.nach_hinten(0.601, 68.925581);
        per.elemente[i].isos.nach_hinten(0.399, 70.924701);
	i++;
        per.elemente[i].elekneg = 1.80;
        per.elemente[i].name = "Germanium";
        per.elemente[i].zeichen = "Ge";
        per.elemente[i].isos.nach_hinten(0.205, 69.924250);
        per.elemente[i].isos.nach_hinten(0.274, 71.922080);
        per.elemente[i].isos.nach_hinten(0.078, 72.923463);
        per.elemente[i].isos.nach_hinten(0.365, 73.921179);
        per.elemente[i].isos.nach_hinten(0.078, 75.921403);
	i++;
        per.elemente[i].elekneg = 2.0;
        per.elemente[i].name = "Arsen";
        per.elemente[i].zeichen = "As";
        per.elemente[i].isos.nach_hinten(1, 74.921596);
	i++;
        per.elemente[i].elekneg = 2.40;
        per.elemente[i].name = "Selen";
        per.elemente[i].zeichen = "Se";
        per.elemente[i].isos.nach_hinten(0.009, 73.922477);
        per.elemente[i].isos.nach_hinten(0.09, 75.919207);
        per.elemente[i].isos.nach_hinten(0.076, 76.919908);
        per.elemente[i].isos.nach_hinten(0.235, 77.917304);
        per.elemente[i].isos.nach_hinten(0.496, 79.916521);
        per.elemente[i].isos.nach_hinten(0.094, 81.916709);
	i++;
        per.elemente[i].elekneg = 2.80;
        per.elemente[i].name = "Brom";
        per.elemente[i].zeichen = "Br";
        per.elemente[i].isos.nach_hinten(0.5069, 78.918336);
        per.elemente[i].isos.nach_hinten(0.4931, 80.916290);
	i++;
        per.elemente[i].elekneg = 0.0;
        per.elemente[i].name = "Krypton";
        per.elemente[i].zeichen = "Kr";
        per.elemente[i].isos.nach_hinten(0.0035, 77.920397);
        per.elemente[i].isos.nach_hinten(0.0225, 79.916375);
        per.elemente[i].isos.nach_hinten(0.1160, 81.913483);
        per.elemente[i].isos.nach_hinten(0.1150, 82.914134);
        per.elemente[i].isos.nach_hinten(0.57, 83.911506);
        per.elemente[i].isos.nach_hinten(0.1730, 85.910614);
	i++;
        per.elemente[i].elekneg = 0.80;
        per.elemente[i].name = "Rubidium";
        per.elemente[i].zeichen = "Rb";
        per.elemente[i].isos.nach_hinten(0.7217, 84.9118);
        per.elemente[i].isos.nach_hinten(0.2784, 86.909184);
	i++;
        per.elemente[i].elekneg = 1.0;
        per.elemente[i].name = "Strontium";
        per.elemente[i].zeichen = "Sr";
        per.elemente[i].isos.nach_hinten(0.0056, 83.913428);
        per.elemente[i].isos.nach_hinten(0.0986, 85.909273);
        per.elemente[i].isos.nach_hinten(0.07, 86.908902);
        per.elemente[i].isos.nach_hinten(0.8258, 87.905625);
	i++;
        per.elemente[i].elekneg = 1.30;
        per.elemente[i].name = "Yttrium";
        per.elemente[i].zeichen = "Y";
        per.elemente[i].isos.nach_hinten(1, 88.905856);
	i++;
        per.elemente[i].elekneg = 1.40;
        per.elemente[i].name = "Zirconium";
        per.elemente[i].zeichen = "Zr";
        per.elemente[i].isos.nach_hinten(0.5145, 89.904708);
        per.elemente[i].isos.nach_hinten(0.1127, 90.905644);
        per.elemente[i].isos.nach_hinten(0.1717, 91.905039);
        per.elemente[i].isos.nach_hinten(0.1733, 93.906319);
        per.elemente[i].isos.nach_hinten(0.0278, 95.908272);
	i++;
        per.elemente[i].elekneg = 1.60;
        per.elemente[i].name = "Niob";
        per.elemente[i].zeichen = "Nb";
        per.elemente[i].isos.nach_hinten(1, 92.906378);
	i++;
        per.elemente[i].elekneg = 1.80;
        per.elemente[i].name = "Molybdn";
        per.elemente[i].zeichen = "Mo";
        per.elemente[i].isos.nach_hinten(0.1484, 91.906809);
        per.elemente[i].isos.nach_hinten(0.0925, 93.905086);
        per.elemente[i].isos.nach_hinten(0.1592, 94.905838);
        per.elemente[i].isos.nach_hinten(0.1668, 95.904676);
        per.elemente[i].isos.nach_hinten(0.0955, 96.906018);
        per.elemente[i].isos.nach_hinten(0.2413, 97.905405);
        per.elemente[i].isos.nach_hinten(0.0963, 99.907473);
	i++;
	i++;
        per.elemente[i].elekneg = 2.20;
        per.elemente[i].name = "Ruthenium";
        per.elemente[i].zeichen = "Ru";
        per.elemente[i].isos.nach_hinten(0.0552, 95.907596);
        per.elemente[i].isos.nach_hinten(0.0188, 97.905287);
        per.elemente[i].isos.nach_hinten(0.127, 98.905937);
        per.elemente[i].isos.nach_hinten(0.126, 99.904218);
        per.elemente[i].isos.nach_hinten(0.17, 100.905581);
        per.elemente[i].isos.nach_hinten(0.316, 101.904348);
        per.elemente[i].isos.nach_hinten(0.187, 103.905422);
	i++;
        per.elemente[i].elekneg = 2.20;
        per.elemente[i].name = "Rhodium";
        per.elemente[i].zeichen = "Rh";
        per.elemente[i].isos.nach_hinten(1, 101.905503);
	i++;
        per.elemente[i].elekneg = 2.20;
        per.elemente[i].name = "Palladium";
        per.elemente[i].zeichen = "Pd";
        per.elemente[i].isos.nach_hinten(0.0102, 101.905609);
        per.elemente[i].isos.nach_hinten(0.1114, 103.904026);
        per.elemente[i].isos.nach_hinten(0.2233, 104.905075);
        per.elemente[i].isos.nach_hinten(0.2733, 105.903475);
        per.elemente[i].isos.nach_hinten(0.2646, 107.903894);
        per.elemente[i].isos.nach_hinten(0.1172, 109.905169);
	i++;
        per.elemente[i].elekneg = 1.90;
        per.elemente[i].name = "Silber";
        per.elemente[i].zeichen = "Ag";
        per.elemente[i].isos.nach_hinten(0.5184, 106.905095);
        per.elemente[i].isos.nach_hinten(0.4816, 108.904754);
	i++;
        per.elemente[i].elekneg = 1.70;
        per.elemente[i].name = "Cadmium";
        per.elemente[i].zeichen = "Cd";
        per.elemente[i].isos.nach_hinten(0.0125, 105.906461);
        per.elemente[i].isos.nach_hinten(0.0089, 107.904176);
        per.elemente[i].isos.nach_hinten(0.1249, 109.903007);
        per.elemente[i].isos.nach_hinten(0.1280, 110.904182);
        per.elemente[i].isos.nach_hinten(0.2413, 111.902761);
        per.elemente[i].isos.nach_hinten(0.1222, 112.904401);
        per.elemente[i].isos.nach_hinten(0.2873, 113.903361);
        per.elemente[i].isos.nach_hinten(0.0749, 115.904758);
	i++;
        per.elemente[i].elekneg = 1.70;
        per.elemente[i].name = "Indium";
        per.elemente[i].zeichen = "In";
        per.elemente[i].isos.nach_hinten(0.043, 112.904056);
        per.elemente[i].isos.nach_hinten(0.957, 114.903875);
	i++;
        per.elemente[i].elekneg = 1.80;
        per.elemente[i].name = "Zinn";
        per.elemente[i].zeichen = "Sn";
        per.elemente[i].isos.nach_hinten(0.0097, 111.904826);
        per.elemente[i].isos.nach_hinten(0.0065, 113.902784);
        per.elemente[i].isos.nach_hinten(0.0036, 114.903348);
        per.elemente[i].isos.nach_hinten(0.147, 115.901744);
        per.elemente[i].isos.nach_hinten(0.077, 116.902954);
        per.elemente[i].isos.nach_hinten(0.243, 117.901607);
        per.elemente[i].isos.nach_hinten(0.086, 118.903310);
        per.elemente[i].isos.nach_hinten(0.324, 119.902199);
        per.elemente[i].isos.nach_hinten(0.046, 121.903440);
        per.elemente[i].isos.nach_hinten(0.056, 123.905271);
	i++;
        per.elemente[i].elekneg = 1.90;
        per.elemente[i].name = "Antimon";
        per.elemente[i].zeichen = "Sb";
        per.elemente[i].isos.nach_hinten(0.5730, 120.903824);
        per.elemente[i].isos.nach_hinten(0.4270, 122.904222);
	i++;
        per.elemente[i].elekneg = 2.10;
        per.elemente[i].name = "Tellur";
        per.elemente[i].zeichen = "Te";
        per.elemente[i].isos.nach_hinten(0.00009, 119.904048);
        per.elemente[i].isos.nach_hinten(0.026, 121.903055);
        per.elemente[i].isos.nach_hinten(0.0091, 122.904278);
        per.elemente[i].isos.nach_hinten(0.0482, 123.902825);
        per.elemente[i].isos.nach_hinten(0.0714, 124.904435);
        per.elemente[i].isos.nach_hinten(0.1895, 125.903310);
        per.elemente[i].isos.nach_hinten(0.3169, 127.904464);
        per.elemente[i].isos.nach_hinten(0.338, 129.906229);
	i++;
        per.elemente[i].elekneg = 2.50;
        per.elemente[i].name = "Iod";
        per.elemente[i].zeichen = "I";
        per.elemente[i].isos.nach_hinten(1, 126.904477);
	i++;
        per.elemente[i].elekneg = 0.0;
        per.elemente[i].name = "Xenon";
        per.elemente[i].zeichen = "Xe";
        per.elemente[i].isos.nach_hinten(0.001, 123.905894);
        per.elemente[i].isos.nach_hinten(0.0009, 125.904281);
        per.elemente[i].isos.nach_hinten(0.0191, 127.903531);
        per.elemente[i].isos.nach_hinten(0.2640, 128.904780);
        per.elemente[i].isos.nach_hinten(0.041, 129.903510);
        per.elemente[i].isos.nach_hinten(0.212, 130.905076);
        per.elemente[i].isos.nach_hinten(0.269, 131.904148);
        per.elemente[i].isos.nach_hinten(0.104, 133.905395);
        per.elemente[i].isos.nach_hinten(0.089, 135.907219);
        i++;
    	per.elemente[i].elekneg = 0.7;
    	per.elemente[i].name = "Caesium";
    	per.elemente[i].zeichen = "Cs";
    	per.elemente[i].isos.nach_hinten(1.000, 132.905433);
	i++;
    	per.elemente[i].elekneg = 0.9;
    	per.elemente[i].name = "Barium";
    	per.elemente[i].zeichen = "Ba";
    	per.elemente[i].isos.nach_hinten(0.0011, 129.906277);
    	per.elemente[i].isos.nach_hinten(0.001, 131.905042);
    	per.elemente[i].isos.nach_hinten(0.0242, 133.904490);
    	per.elemente[i].isos.nach_hinten(0.0659, 134.905665);
    	per.elemente[i].isos.nach_hinten(0.0785, 135.905816);
    	per.elemente[i].isos.nach_hinten(0.1123, 136.905816);
    	per.elemente[i].isos.nach_hinten(0.717, 137.905236);
	i++;
    	per.elemente[i].elekneg = 1.1;
    	per.elemente[i].name = "Lanthan";
    	per.elemente[i].zeichen = "La";
    	per.elemente[i].isos.nach_hinten(0.0009, 137.907114);
    	per.elemente[i].isos.nach_hinten(0.9991, 138.906355);
	i++;
    	per.elemente[i].elekneg = 1.1;
    	per.elemente[i].name = "Cer";
    	per.elemente[i].zeichen = "Ce";
    	per.elemente[i].isos.nach_hinten(0.0019, 135.907140);
    	per.elemente[i].isos.nach_hinten(0.0025, 137.905996);
    	per.elemente[i].isos.nach_hinten(0.8848, 139.905442);
    	per.elemente[i].isos.nach_hinten(0.1108, 141.909249);
	i++;
    	per.elemente[i].elekneg = 1.1;
    	per.elemente[i].name = "Praseodym";
    	per.elemente[i].zeichen = "Pr";
    	per.elemente[i].isos.nach_hinten(1.000, 140.907657);
	i++;
    	per.elemente[i].elekneg = 1.2;
    	per.elemente[i].name = "Neodym";
    	per.elemente[i].zeichen = "Nd";
    	per.elemente[i].isos.nach_hinten(0.2713, 141.907731);
    	per.elemente[i].isos.nach_hinten(0.1218, 142.909823);
    	per.elemente[i].isos.nach_hinten(0.238, 143.910096);
    	per.elemente[i].isos.nach_hinten(0.083, 144.912582);
    	per.elemente[i].isos.nach_hinten(0.1719, 145.913126);
    	per.elemente[i].isos.nach_hinten(0.0576, 147.916901);                             
    	per.elemente[i].isos.nach_hinten(0.0564, 149.920900);
	i++;
	i++;
    	per.elemente[i].elekneg = 1.2;
    	per.elemente[i].name = "Samarium";
    	per.elemente[i].zeichen = "Sm";
    	per.elemente[i].isos.nach_hinten(0.031, 143.912009);
    	per.elemente[i].isos.nach_hinten(0.150, 146.914907);
    	per.elemente[i].isos.nach_hinten(0.113, 147.914832);
    	per.elemente[i].isos.nach_hinten(0.138, 148.917193);
    	per.elemente[i].isos.nach_hinten(0.074, 149.917285);
    	per.elemente[i].isos.nach_hinten(0.257, 151.919741);
    	per.elemente[i].isos.nach_hinten(0.227, 153.922218);
        i++;
    	per.elemente[i].elekneg = 1.2;
    	per.elemente[i].name = "Europium";
    	per.elemente[i].zeichen = "Eu";
    	per.elemente[i].isos.nach_hinten(0.478, 150.919860);
    	per.elemente[i].isos.nach_hinten(0.522, 152.921243);
        i++;
    	per.elemente[i].elekneg = 1.1;
    	per.elemente[i].name = "Gadolinium";
    	per.elemente[i].zeichen = "Gd";
    	per.elemente[i].isos.nach_hinten(0.002, 151.919803);
    	per.elemente[i].isos.nach_hinten(0.0218, 153.920876);
    	per.elemente[i].isos.nach_hinten(0.148, 154.822629);
    	per.elemente[i].isos.nach_hinten(0.2047, 155.922130);
    	per.elemente[i].isos.nach_hinten(0.1565, 156.923967);
    	per.elemente[i].isos.nach_hinten(0.2484, 157.924111);
    	per.elemente[i].isos.nach_hinten(0.2186, 159.927061);
        i++;
    	per.elemente[i].elekneg = 1.2;
    	per.elemente[i].name = "Terbium";
    	per.elemente[i].zeichen = "Tb";
    	per.elemente[i].isos.nach_hinten(1.000, 158.925350);
        i++;
    	per.elemente[i].elekneg = 1.2;
    	per.elemente[i].name = "Dysprosium";
    	per.elemente[i].zeichen = "Dy";
    	per.elemente[i].isos.nach_hinten(0.0006, 155.924287);
    	per.elemente[i].isos.nach_hinten(0.001, 157.924412);
    	per.elemente[i].isos.nach_hinten(0.0234, 159.925203);
    	per.elemente[i].isos.nach_hinten(0.189, 160.926939);
    	per.elemente[i].isos.nach_hinten(0.255, 161.926805);
    	per.elemente[i].isos.nach_hinten(0.249, 162.928737);
    	per.elemente[i].isos.nach_hinten(0.282, 163.929183);
        i++;
    	per.elemente[i].elekneg = 1.2;
    	per.elemente[i].name = "Holmium";
    	per.elemente[i].zeichen = "Ho";
    	per.elemente[i].isos.nach_hinten(1.000, 164.930332);
        i++;
    	per.elemente[i].elekneg = 1.3;
    	per.elemente[i].name = "Erbium";
    	per.elemente[i].zeichen = "Er";
    	per.elemente[i].isos.nach_hinten(0.0014, 161.928787);
    	per.elemente[i].isos.nach_hinten(0.0161, 163.929211);
    	per.elemente[i].isos.nach_hinten(0.336, 165.930305);
    	per.elemente[i].isos.nach_hinten(0.2295, 166.932061);
    	per.elemente[i].isos.nach_hinten(0.268, 167.932383);
    	per.elemente[i].isos.nach_hinten(0.149, 169.935476);
        i++;
    	per.elemente[i].elekneg = 1.2;
    	per.elemente[i].name = "Thulium";
    	per.elemente[i].zeichen = "Tm";
    	per.elemente[i].isos.nach_hinten(1.000, 168.934225);
        i++;
    	per.elemente[i].elekneg = 1.1;
    	per.elemente[i].name = "Ytterbium";
    	per.elemente[i].zeichen = "Yb";
    	per.elemente[i].isos.nach_hinten(0.0013, 167.933908);
    	per.elemente[i].isos.nach_hinten(0.0305, 169.934774);
    	per.elemente[i].isos.nach_hinten(0.143, 170.936338);
    	per.elemente[i].isos.nach_hinten(0.219, 171.936393);
    	per.elemente[i].isos.nach_hinten(0.1612, 172.938222);
    	per.elemente[i].isos.nach_hinten(0.318, 173.938873);
    	per.elemente[i].isos.nach_hinten(0.127, 175.942576);
        i++;
    	per.elemente[i].elekneg = 1.2;
    	per.elemente[i].name = "Lutetium";
    	per.elemente[i].zeichen = "Lu";
    	per.elemente[i].isos.nach_hinten(0.974, 174.940785);
    	per.elemente[i].isos.nach_hinten(0.026, 175.942694);
        i++;
    	per.elemente[i].elekneg = 1.3;
    	per.elemente[i].name = "Hafnium";
    	per.elemente[i].zeichen = "Hf";
    	per.elemente[i].isos.nach_hinten(0.0016, 173.940065);
    	per.elemente[i].isos.nach_hinten(0.052, 175.941420);
    	per.elemente[i].isos.nach_hinten(0.186, 176.943233);
    	per.elemente[i].isos.nach_hinten(0.271, 177.943710);
    	per.elemente[i].isos.nach_hinten(0.1374, 178.945827);
    	per.elemente[i].isos.nach_hinten(0.352, 179.946561);
	i++;
    	per.elemente[i].elekneg = 1.5;
    	per.elemente[i].name = "Tantal";
    	per.elemente[i].zeichen = "Ta";
    	per.elemente[i].isos.nach_hinten(0.00012, 179.947489);
    	per.elemente[i].isos.nach_hinten(0.9999, 180.948014);
	i++;
    	per.elemente[i].elekneg = 1.7;
    	per.elemente[i].name = "Wolfram";
    	per.elemente[i].zeichen = "W";
    	per.elemente[i].isos.nach_hinten(0.0013, 179.946727);
    	per.elemente[i].isos.nach_hinten(0.263, 181.948225);
    	per.elemente[i].isos.nach_hinten(0.143, 182.950245);
    	per.elemente[i].isos.nach_hinten(0.3067, 183.950953);
    	per.elemente[i].isos.nach_hinten(0.236, 185.954377);
        i++;
    	per.elemente[i].elekneg = 1.9;
    	per.elemente[i].name = "Rhenium";
    	per.elemente[i].zeichen = "Re";
    	per.elemente[i].isos.nach_hinten(0.374, 184.952977);
    	per.elemente[i].isos.nach_hinten(0.626, 186.955765);
        i++;
    	per.elemente[i].elekneg = 2.2;
    	per.elemente[i].name = "Osmium";
    	per.elemente[i].zeichen = "Os";
    	per.elemente[i].isos.nach_hinten(0.0002, 183.952514);
    	per.elemente[i].isos.nach_hinten(0.0158, 185.953852);
    	per.elemente[i].isos.nach_hinten(0.016, 186.955762);
    	per.elemente[i].isos.nach_hinten(0.133, 187.955850);
    	per.elemente[i].isos.nach_hinten(0.161, 188.958156);
    	per.elemente[i].isos.nach_hinten(0.264, 189.958455);
    	per.elemente[i].isos.nach_hinten(0.410, 191.961487);
        i++;
    	per.elemente[i].elekneg = 2.2;
    	per.elemente[i].name = "Iridium";
    	per.elemente[i].zeichen = "Ir";
    	per.elemente[i].isos.nach_hinten(0.373, 190.960603);
    	per.elemente[i].isos.nach_hinten(0.627, 192.962942);
        i++;
    	per.elemente[i].elekneg = 2.2;
    	per.elemente[i].name = "Platin";
    	per.elemente[i].zeichen = "Pt";
    	per.elemente[i].isos.nach_hinten(0.0001, 189.959937);
    	per.elemente[i].isos.nach_hinten(0.0079, 191.961049);
    	per.elemente[i].isos.nach_hinten(0.329, 193.962679);
    	per.elemente[i].isos.nach_hinten(0.338, 194.964785);
    	per.elemente[i].isos.nach_hinten(0.253, 195.964947);
    	per.elemente[i].isos.nach_hinten(0.072, 197.967879);
        i++;
    	per.elemente[i].elekneg = 2.4;
    	per.elemente[i].name = "Gold";
    	per.elemente[i].zeichen = "Au";
    	per.elemente[i].isos.nach_hinten(1.000, 196.966560);
        i++;
    	per.elemente[i].elekneg = 1.9;
    	per.elemente[i].name = "Quecksilber";
    	per.elemente[i].zeichen = "Hg";
    	per.elemente[i].isos.nach_hinten(0.0015, 195.965812);
    	per.elemente[i].isos.nach_hinten(0.101, 197.966760);
    	per.elemente[i].isos.nach_hinten(0.170, 198.968269);
    	per.elemente[i].isos.nach_hinten(0.231, 199.968316);
    	per.elemente[i].isos.nach_hinten(0.132, 200.970293);
    	per.elemente[i].isos.nach_hinten(0.2965, 201.970632);
    	per.elemente[i].isos.nach_hinten(0.068, 203.973481);
        i++;
    	per.elemente[i].elekneg = 1.8;
    	per.elemente[i].name = "Thallium";
    	per.elemente[i].zeichen = "Tl";
    	per.elemente[i].isos.nach_hinten(0.2952, 202.972336);
    	per.elemente[i].isos.nach_hinten(0.7048, 204.974410);
        i++;
    	per.elemente[i].elekneg = 1.8;
    	per.elemente[i].name = "Blei";
    	per.elemente[i].zeichen = "Pb";
    	per.elemente[i].isos.nach_hinten(0.014, 203.973037);
    	per.elemente[i].isos.nach_hinten(0.241, 205.974455);
    	per.elemente[i].isos.nach_hinten(0.221, 206.975885);
    	per.elemente[i].isos.nach_hinten(0.524, 207.976641);
        i++;
    	per.elemente[i].elekneg = 1.9;
    	per.elemente[i].name = "Bismut";
    	per.elemente[i].zeichen = "Bi";
    	per.elemente[i].isos.nach_hinten(1.000, 208.980388);
        i++;
        i++;
        i++;
        i++;
        i++;
        i++;
        i++;
    	per.elemente[i].elekneg = 1.3;
    	per.elemente[i].name = "Thorium";
    	per.elemente[i].zeichen = "Th";
    	per.elemente[i].isos.nach_hinten(1.000, 232.038054);
        i++;
        i++;
    	per.elemente[i].elekneg = 1.7;
    	per.elemente[i].name = "Uran";
    	per.elemente[i].zeichen = "U";
    	per.elemente[i].isos.nach_hinten(0.000006, 234.040947);
    	per.elemente[i].isos.nach_hinten(0.0072, 235.043925);
    	per.elemente[i].isos.nach_hinten(0.9927, 238.050786);
        
    }
    //ende install
}
